#include "main.h"

RenderWindow window;

Event event;

Input input;
Display display;

bool menu = true;
bool setting_menu = false;
bool play = false;

int main()
{
	window.create(VideoMode(WIN_WIDTH, WIN_HEIGHT), "BlockDash", Style::Fullscreen);

	while (window.isOpen())
	{
		while (window.pollEvent(event))
		{
			input.InputHandler(event, window);
			CheckBtn(window, event);
		}

		window.clear(Color::White);

		if (menu)
		{
			display.board_menu(window);
			
		}

		if (play)
		{
			display.level1(window);
		}

		if (setting_menu)
		{
			display.board_setting(window);
		}

		window.display();
	}
}

void CheckBtn(RenderWindow& window, Event event)
{
	float mouse_x = Mouse::getPosition(window).x;
	float mouse_y = Mouse::getPosition(window).y;

	if (event.type == Event::Closed)
		window.close();

	if (event.type == Event::KeyPressed)
	{
		if (event.key.code == Keyboard::Escape)
		{
			if (setting_menu)
				setting_menu = false;
			else
				setting_menu = true;
		}
	}

	if (event.type == Event::MouseButtonPressed)
	{
		if (((mouse_x > WIN_WIDTH - 10 - (150 * setting_s) && mouse_x < WIN_WIDTH - 10) &&
			(mouse_y > 10 && mouse_y < 10 + (setting_s * 150))) &&
			event.mouseButton.button == Mouse::Left)
			setting_menu = true;

		if (mouse_x > (WIN_WIDTH / 2) - (475 / 2) && mouse_x < (WIN_WIDTH / 2) + (475 / 2) &&
			mouse_y >(WIN_HEIGHT / 1.3) - (150 / 2) && mouse_y < (WIN_HEIGHT / 1.3) + (150 / 2) &&
			event.mouseButton.button == Mouse::Left)
		{
			play = true;
			menu = false;
		}

		if (mouse_x > (WIN_WIDTH/2)-(350/2) && mouse_x < (WIN_WIDTH/2)+(350/2) &&
			mouse_y >(WIN_HEIGHT / 1.5) - (125 / 2) && mouse_y < (WIN_HEIGHT / 1.5) + (125 / 2)&&
			event.mouseButton.button == Mouse::Left)
		{
			if (play)
			{
				play = false;
				menu = true;
			}
			else
				window.close();

		}
	}
}