#include "input.h"

Input::Input()
{
	button.left = false;
	button.right = false;
	button.space = false;
	button.dash = false;
}

Input::Button Input::GetButton(void) const
{
	return button;
}

void Input::InputHandler(Event event, RenderWindow& window)
{
	if (event.type == Event::KeyPressed)
	{
		switch (event.key.code)
		{
		case Keyboard::Q:
			button.left = true;
			break;
		case Keyboard::D:
			button.right = true;
			break;
		case Keyboard::Space:
			button.space = true;
			break;

		default:
			break;
		}
	}
	if (event.type == Event::KeyReleased)
	{
		switch (event.key.code)
		{
		case Keyboard::Q:
			button.left = false;
			break;
		case Keyboard::D:
			button.right = false;
			break;
		case Keyboard::Space:
			button.space = false;
			break;

		default:
			break;
		}
	}

	if (event.type == Event::MouseButtonPressed)
	{
		if (event.mouseButton.button == Mouse::Left)
			button.dash = true;
	}

	if (event.type == Event::MouseButtonReleased)
	{
		if (event.mouseButton.button == Mouse::Left)
			button.dash = false;
	}
}